# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200711-07.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(27824);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200711-07");
 script_cve_id("CVE-2007-4965");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200711-07
(Python: User-assisted execution of arbitrary code)


    Slythers Bro discovered multiple integer overflows in the imageop
    module, one of them in the tovideo() method, in various locations in
    files imageop.c, rbgimgmodule.c, and also in other files.
  
Impact

    A remote attacker could entice a user to process specially crafted
    images with an application using the Python imageop module, resulting
    in the execution of arbitrary code with the privileges of the user
    running the application, or a Denial of Service. Note that this
    vulnerability may or may not be exploitable, depending on the
    application using the module.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4965


Solution: 
    All Python 2.3.x users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-lang/python-2.3.6-r3"
    All Python 2.4.x users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-lang/python-2.4.4-r6"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200711-07] Python: User-assisted execution of arbitrary code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Python: User-assisted execution of arbitrary code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-lang/python", unaffected: make_list("rge 2.3.6-r3", "ge 2.4.4-r6"), vulnerable: make_list("lt 2.4.4-r6")
)) { security_warning(0); exit(0); }
