# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200711-25.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(28264);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200711-25");
 script_cve_id("CVE-2007-5925");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200711-25
(MySQL: Denial of Service)


    Joe Gallo and Artem Russakovskii reported an error in the
    convert_search_mode_to_innobase() function in ha_innodb.cc in the
    InnoDB engine that is leading to a failed assertion when handling
    CONTAINS operations.
  
Impact

    A remote authenticated attacker with ALTER privileges could send a
    specially crafted request to a vulnerable database server possibly
    leading to a Denial of Service.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5925


Solution: 
    All MySQL users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-db/mysql-5.0.44-r2"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200711-25] MySQL: Denial of Service");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'MySQL: Denial of Service');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-db/mysql", unaffected: make_list("ge 5.0.44-r2"), vulnerable: make_list("lt 5.0.44-r2")
)) { security_warning(0); exit(0); }
