# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200711-27.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(28266);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200711-27");
 script_cve_id("CVE-2007-5395");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200711-27
(Link Grammar: User-assisted execution of arbitrary code)


    Alin Rad Pop from Secunia Research discovered a boundary error in the
    function separate_sentence() in file tokenize.c when processing an
    overly long word which might lead to a stack-based buffer overflow.
  
Impact

    A remote attacker could entice a user to parse a specially crafted
    sentence, resulting in the remote execution of arbitrary code with the
    privileges of the user running the application. Note that this
    vulnerability may be triggered by an application using Link Grammar to
    parse sentences (e.g. AbiWord).
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5395


Solution: 
    All Link Grammar users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-libs/link-grammar-4.2.4-r1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200711-27] Link Grammar: User-assisted execution of arbitrary code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Link Grammar: User-assisted execution of arbitrary code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-libs/link-grammar", unaffected: make_list("ge 4.2.4-r1"), vulnerable: make_list("lt 4.2.4-r1")
)) { security_warning(0); exit(0); }
