# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200711-29.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(28318);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200711-29");
 script_cve_id("CVE-2007-4572", "CVE-2007-5398");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200711-29
(Samba: Execution of arbitrary code)


    Two vulnerabilities have been reported in nmbd. Alin Rad Pop (Secunia
    Research) discovered a boundary checking error in the
    reply_netbios_packet() function which could lead to a stack-based
    buffer overflow (CVE-2007-5398). The Samba developers discovered a
    boundary error when processing GETDC logon requests also leading to a
    buffer overflow (CVE-2007-4572).
  
Impact

    To exploit the first vulnerability a remote unauthenticated attacker
    could send specially crafted WINS "Name Registration" requests followed
    by a WINS "Name Query" request. This might lead to execution of
    arbitrary code with elevated privileges. Note that this vulnerability
    is exploitable only when WINS server support is enabled in Samba. The
    second vulnerability could be exploited by sending specially crafted
    "GETDC" mailslot requests, but requires Samba to be configured as a
    Primary or Backup Domain Controller. It is not believed the be
    exploitable to execute arbitrary code.
  
Workaround

    To work around the first vulnerability, disable WINS support in Samba
    by setting "wins support = no" in the "global" section of your
    smb.conf and restart Samba.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-4572
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5398


Solution: 
    The Samba 3.0.27 ebuild that resolves both vulnerabilities is currently
    masked due to a regression in the patch for the second vulnerability.
    Since no working patch exists yet, all Samba users should upgrade to
    3.0.26a-r2, which contains a fix for the first vulnerability
    (CVE-2007-5398):
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-fs/samba-3.0.26a-r2"
    An update to this temporary GLSA will be sent when the second
    vulnerability will be fixed.
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200711-29] Samba: Execution of arbitrary code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Samba: Execution of arbitrary code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-fs/samba", unaffected: make_list("ge 3.0.26a-r2"), vulnerable: make_list("lt 3.0.26a-r2")
)) { security_hole(0); exit(0); }
