# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200711-32.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(28321);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200711-32");
 script_cve_id("CVE-2007-5940");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200711-32
(Feynmf: Insecure temporary file creation)


    Kevin B. McCarty discovered that the feynmf.pl script creates a
    temporary "properly list" file at the location "$TMPDIR/feynmf$PID.pl",
    where $PID is the process ID.
  
Impact

    A local attacker could create symbolic links in the directory where the
    temporary files are written, pointing to a valid file somewhere on the
    filesystem that is writable by the user running Feynmf. When Feynmf
    writes the temporary file, the target valid file would then be
    overwritten with the contents of the Feynmf temporary file.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5940


Solution: 
    All Feynmf users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-tex/feynmf-1.08-r2"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200711-32] Feynmf: Insecure temporary file creation");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Feynmf: Insecure temporary file creation');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-tex/feynmf", unaffected: make_list("ge 1.08-r2"), vulnerable: make_list("lt 1.08-r2")
)) { security_warning(0); exit(0); }
