# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200712-01.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(29231);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200712-01");
 script_cve_id("CVE-2007-5200");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200712-01
(Hugin: Insecure temporary file creation)


    Suse Linux reported that Hugin creates the
    "hugin_debug_optim_results.txt" temporary file in an insecure manner.
  
Impact

    A local attacker could exploit this vulnerability with a symlink
    attack, potentially overwriting an arbitrary file with the privileges
    of the user running the application.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5200


Solution: 
    All Hugin users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=media-gfx/hugin-0.6.1-r1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200712-01] Hugin: Insecure temporary file creation");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Hugin: Insecure temporary file creation');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "media-gfx/hugin", unaffected: make_list("rge 0.6.1-r1", "ge 0.7_beta4-r1"), vulnerable: make_list("lt 0.7_beta4-r1")
)) { security_warning(0); exit(0); }
