# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200712-04.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(29291);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200712-04");
 script_cve_id("CVE-2007-5503");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200712-04
(Cairo: User-assisted execution of arbitrary code)


    Multiple integer overflows were reported, one of which Peter Valchev
    (Google Security) found to be leading to a heap-based buffer overflow
    in the cairo_image_surface_create_from_png() function that processes
    PNG images.
  
Impact

    A remote attacker could entice a user to view or process a specially
    crafted PNG image file in an application linked against Cairo, possibly
    leading to the execution of arbitrary code with the privileges of the
    user running the application.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-5503


Solution: 
    All Cairo users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=x11-libs/cairo-1.4.12"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200712-04] Cairo: User-assisted execution of arbitrary code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Cairo: User-assisted execution of arbitrary code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "x11-libs/cairo", unaffected: make_list("ge 1.4.12"), vulnerable: make_list("lt 1.4.12")
)) { security_warning(0); exit(0); }
