# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200712-11.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(29716);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200712-11");
 script_cve_id("CVE-2007-6249");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200712-11
(Portage: Information disclosure)


    Mike Frysinger reported that the "etc-update" utility uses temporary
    files with the standard umask, which results in the files being
    world-readable when merging configuration files in a default setup.
  
Impact

    A local attacker could access sensitive information when configuration
    files are being merged.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6249


Solution: 
    All Portage users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=sys-apps/portage-2.1.3.11"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200712-11] Portage: Information disclosure");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Portage: Information disclosure');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "sys-apps/portage", unaffected: make_list("ge 2.1.3.11"), vulnerable: make_list("lt 2.1.3.11")
)) { security_warning(0); exit(0); }
