# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200712-12.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(29717);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200712-12");
 script_cve_id("CVE-2007-6122");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200712-12
(IRC Services: Denial of Service)


    loverboy reported that the "default_encrypt()" function in file
    encrypt.c does not properly handle overly long passwords.
  
Impact

    A remote attacker could provide an overly long password to the
    vulnerable server, resulting in a Denial of Service.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6122


Solution: 
    All IRC Services users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-irc/ircservices-5.0.63"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200712-12] IRC Services: Denial of Service");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'IRC Services: Denial of Service');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-irc/ircservices", unaffected: make_list("ge 5.0.63"), vulnerable: make_list("lt 5.0.63")
)) { security_warning(0); exit(0); }
