# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200712-15.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(29812);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200712-15");
 script_cve_id("CVE-2007-6351", "CVE-2007-6352");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200712-15
(libexif: Multiple vulnerabilities)


    Meder Kydyraliev (Google Security) discovered an integer overflow
    vulnerability in the exif_data_load_data_thumbnail() function leading
    to a memory corruption (CVE-2007-6352) and an infinite recursion in the
    exif_loader_write() function (CVE-2007-6351).
  
Impact

    An attacker could entice the user of an application making use of
    libexif to load an image file with specially crafted Exif tags,
    possibly resulting in the execution of arbitrary code with the
    privileges of the user running the application or a Denial of Service.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6351
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6352


Solution: 
    All libexif users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=media-libs/libexif-0.6.16-r1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200712-15] libexif: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'libexif: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "media-libs/libexif", unaffected: make_list("ge 0.6.16-r1"), vulnerable: make_list("lt 0.6.16-r1")
)) { security_warning(0); exit(0); }
