# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200712-19.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(29816);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200712-19");
 script_cve_id("CVE-2007-6437");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200712-19
(Syslog-ng: Denial of Service)


    Oriol Carreras reported a NULL pointer dereference in the
    log_msg_parse() function when processing timestamps without a
    terminating whitespace character.
  
Impact

    A remote attacker could send a specially crafted event to a vulnerable
    Syslog-ng server, resulting in a crash.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6437


Solution: 
    All Syslog-ng users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-admin/syslog-ng-2.0.6"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200712-19] Syslog-ng: Denial of Service");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Syslog-ng: Denial of Service');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-admin/syslog-ng", unaffected: make_list("ge 2.0.6"), vulnerable: make_list("lt 2.0.6")
)) { security_warning(0); exit(0); }
