# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200712-24.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(29821);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200712-24");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200712-24
(AMD64 x86 emulation GTK+ library: User-assisted execution of arbitrary code)


    The Cairo versions used by the AMD64 x86 emulation GTK+ libraries were
    vulnerable to integer overflow vulnerabilities (GLSA 200712-04).
  
Impact

    A remote attacker could entice a user to view or process a specially
    crafted PNG image file in an application linked against Cairo, possibly
    leading to the execution of arbitrary code with the privileges of the
    user running the application.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://www.gentoo.org/security/en/glsa/glsa-200712-04.xml


Solution: 
    All AMD64 x86 emulation GTK+ library users should upgrade to the latest
    version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-emulation/emul-linux-x86-gtklibs-20071214"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2007 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200712-24] AMD64 x86 emulation GTK+ library: User-assisted execution of arbitrary code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'AMD64 x86 emulation GTK+ library: User-assisted execution of arbitrary code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-emulation/emul-linux-x86-gtklibs", arch: "amd64", unaffected: make_list("ge 20071214"), vulnerable: make_list("lt 20071214")
)) { security_warning(0); exit(0); }
