# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200801-02.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(29906);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200801-02");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200801-02
(R: Multiple vulnerabilities)


    R includes a copy of PCRE which is vulnerable to multiple buffer
    overflows and memory corruptions vulnerabilities (GLSA 200711-30).
  
Impact

    An attacker could entice a user to process specially crafted regular
    expressions with R, which could possibly lead to the execution of
    arbitrary code, a Denial of Service or the disclosure of sensitive
    information.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://www.gentoo.org/security/en/glsa/glsa-200711-30.xml


Solution: 
    All R users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-lang/R-2.2.1-r1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200801-02] R: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'R: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-lang/R", unaffected: make_list("ge 2.2.1-r1"), vulnerable: make_list("lt 2.2.1-r1")
)) { security_warning(0); exit(0); }
