# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200801-04.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(29908);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200801-04");
 script_cve_id("CVE-2007-6599");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200801-04
(OpenAFS: Denial of Service)


    Russ Allbery, Jeffrey Altman, Dan Hyde and Thomas Mueller discovered a
    race condition due to an improper handling of the clients callbacks
    lists.
  
Impact

    A remote attacker could construct cases which trigger the race
    condition, resulting in a server crash.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6599


Solution: 
    All OpenAFS users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-fs/openafs-1.4.6"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200801-04] OpenAFS: Denial of Service");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'OpenAFS: Denial of Service');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-fs/openafs", unaffected: make_list("ge 1.4.6"), vulnerable: make_list("lt 1.4.6")
)) { security_warning(0); exit(0); }
