# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200801-08.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(30032);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200801-08");
 script_cve_id("CVE-2007-6613");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200801-08
(libcdio: User-assisted execution of arbitrary code)


    Devon Miller reported a boundary error in the "print_iso9660_recurse()"
    function in files cd-info.c and iso-info.c when processing long
    filenames within Joliet images.
  
Impact

    A remote attacker could entice a user to open a specially crafted ISO
    image in the cd-info and iso-info applications, resulting in the
    execution of arbitrary code with the privileges of the user running the
    application. Applications linking against shared libraries of libcdio
    are not affected.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6613


Solution: 
    All libcdio users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=dev-libs/libcdio-0.78.2-r4"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200801-08] libcdio: User-assisted execution of arbitrary code");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'libcdio: User-assisted execution of arbitrary code');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "dev-libs/libcdio", unaffected: make_list("ge 0.78.2-r4"), vulnerable: make_list("lt 0.78.2-r4")
)) { security_warning(0); exit(0); }
