# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200801-13.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(30118);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200801-13");
 script_cve_id("CVE-2008-0285");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200801-13
(ngIRCd: Denial of Service)


    The IRC_PART() function in the file irc-channel.c does not properly
    check the number of parameters, referencing an invalid pointer if no
    channel is supplied.
  
Impact

    A remote attacker can exploit this vulnerability to crash the ngIRCd
    daemon.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0285


Solution: 
    All ngIRCd users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=net-irc/ngircd-0.10.4"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200801-13] ngIRCd: Denial of Service");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'ngIRCd: Denial of Service');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "net-irc/ngircd", unaffected: make_list("ge 0.10.4"), vulnerable: make_list("lt 0.10.4")
)) { security_warning(0); exit(0); }
