# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200801-19.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(30136);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200801-19");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200801-19
(GOffice: Multiple vulnerabilities)


    GOffice includes a copy of PCRE which is vulnerable to multiple buffer
    overflows and memory corruptions vulnerabilities (GLSA 200711-30).
  
Impact

    An attacker could entice a user to open specially crafted documents
    with GOffice, which could possibly lead to the execution of arbitrary
    code, a Denial of Service or the disclosure of sensitive information.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://www.gentoo.org/security/en/glsa/glsa-200711-30.xml


Solution: 
    All GOffice 0.4.x users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=x11-libs/goffice-0.4.3"
    All GOffice 0.6.x users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=x11-libs/goffice-0.6.1"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200801-19] GOffice: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'GOffice: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "x11-libs/goffice", unaffected: make_list("ge 0.6.1", "rge 0.4.3"), vulnerable: make_list("lt 0.6.1")
)) { security_warning(0); exit(0); }
