# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200802-03.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(31033);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200802-03");
 script_cve_id("CVE-2007-6018");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200802-03
(Horde IMP: Security bypass)


    Ulf Harnhammar, Secunia Research discovered that the "frame" and
    "frameset" HTML tags are not properly filtered out. He also reported
    that certain HTTP requests are executed without being checked.
  
Impact

    A remote attacker could entice a user to open a specially crafted HTML
    e-mail, possibly resulting in the deletion of arbitrary e-mail
    messages.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6018


Solution: 
    All Horde IMP users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-apps/horde-imp-4.1.6"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200802-03] Horde IMP: Security bypass");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Horde IMP: Security bypass');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-apps/horde-imp", unaffected: make_list("ge 4.1.6"), vulnerable: make_list("lt 4.1.6")
)) { security_warning(0); exit(0); }
