# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200803-04.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(31379);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200803-04");
 script_cve_id("CVE-2007-6611");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200803-04
(Mantis: Cross-Site Scripting)


    seiji reported that the filename for the uploaded file in
    bug_report.php is not properly sanitised before being stored.
  
Impact

    A remote attacker could upload a file with a specially crafted to a bug
    report, resulting in the execution of arbitrary HTML and script code
    within the context of the users\'s browser. Note that this vulnerability
    is only exploitable by authenticated users.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6611


Solution: 
    All Mantis users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-apps/mantisbt-1.0.8-r1"
  

Risk factor : Low
';
 script_description(english: desc);
 script_copyright(english: "(C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200803-04] Mantis: Cross-Site Scripting");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Mantis: Cross-Site Scripting');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-apps/mantisbt", unaffected: make_list("ge 1.0.8-r1"), vulnerable: make_list("lt 1.0.8-r1")
)) { security_warning(0); exit(0); }
