# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200803-06.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(31381);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200803-06");
 script_cve_id("CVE-2008-0932");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200803-06
(SWORD: Shell command injection)


    Dan Dennison reported that the diatheke.pl script used in SWORD does
    not properly sanitize shell meta-characters in the "range" parameter
    before processing it.
  
Impact

    A remote attacker could provide specially crafted input to a vulnerable
    application, possibly resulting in the remote execution of arbitrary
    shell commands with the privileges of the user running SWORD (generally
    the web server account).
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0932


Solution: 
    All SWORD users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=app-text/sword-1.5.8-r2"
  

Risk factor : High
';
 script_description(english: desc);
 script_copyright(english: "(C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200803-06] SWORD: Shell command injection");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'SWORD: Shell command injection');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "app-text/sword", unaffected: make_list("ge 1.5.8-r2"), vulnerable: make_list("lt 1.5.8-r2")
)) { security_hole(0); exit(0); }
