# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200803-09.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2006 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi <mikhail@nessus.org>

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(31384);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200803-09");
 script_cve_id("CVE-2008-1080", "CVE-2008-1081", "CVE-2008-1082");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200803-09
(Opera: Multiple vulnerabilities)


    Mozilla discovered that Opera does not handle input to file form fields
    properly, allowing scripts to manipulate the file path (CVE-2008-1080).
    Max Leonov found out that image comments might be treated as scripts,
    and run within the wrong security context (CVE-2008-1081). Arnaud
    reported that a wrong representation of DOM attribute values of
    imported XML documents allows them to bypass sanitization filters
    (CVE-2008-1082).
  
Impact

    A remote attacker could entice a user to upload a file with a known
    path by entering text into a specially crafted form, to execute scripts
    outside intended security boundaries and conduct Cross-Site Scripting
    attacks.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-1080
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-1081
    http://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-1082


Solution: 
    All Opera users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=www-client/opera-9.26"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2008 Michel Arboi <mikhail@nessus.org>");
 script_name(english: "[GLSA-200803-09] Opera: Multiple vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'Opera: Multiple vulnerabilities');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "www-client/opera", unaffected: make_list("ge 9.26"), vulnerable: make_list("lt 9.26")
)) { security_warning(0); exit(0); }
