#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote RTSP server suffers from a buffer overflow vulnerability. 

Description :

The remote host is running Helix DNA Server or Helix Server, a media
streaming server. 

The version of the Helix server installed on the remote host contains
a heap overflow involving an invalid 'LoadTestPassword' field.  An
unauthenticated remote attacker can leverage this flaw using a simple
'DESCRIBE' request to crash the affected application and possibly to
execute arbitrary code subject to the privileges of the user id under
which it runs, which by default on Windows is LOCAL SYSTEM. 

See also :

http://gleg.net/helix.txt
http://www.securityfocus.com/archive/1/463333/30/0/threaded
http://lists.helixcommunity.org/pipermail/server-cvs/2007-January/003783.html
http://docs.real.com/docs/security/SecurityUpdate032107Server.pdf

Solution :

Upgrade to Helix Server / Helix DNA Server version 11.1.3 or later. 

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";


if (description)
{
  script_id(24876);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2006-6026");
  script_bugtraq_id(21141, 23068);
  script_xref(name:"OSVDB", value:"30466");

  script_name(english:"Helix Server LoadTestPassword field Overflow Vulnerability");
  script_summary(english:"Checks Helix server banner");

  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Gain root remotely");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("find_service2.nasl");
  script_require_ports("Services/rtsp", 554);

  exit(0);
}


include("http_func.inc");
include("misc_func.inc");


port = get_kb_item("Services/rstp");
if (!port) port = 554;
if (!get_port_state(port)) exit(0);


soc = open_sock_tcp(port);
if (!soc) exit(0);


# Grab the banner.
req = string(
  "OPTIONS * RTSP/1.0\r\n", 
  "CSeq: 1\r\n",
  "\r\n"
);
send(socket:soc, data:req);
res = http_recv(socket:soc);
close(soc);
if (res == NULL) exit(0);


# Pull out the server information.
server = egrep(pattern:"^Server:", string:res);
if (!server) 
{
  via = egrep(pattern:"^Via: .*\(.*\)", string:res);
  if (via) server = ereg_replace(pattern:"^Via: .*\((.*)\).*", replace:"\1", string:via);
}
else server -= "Server: ";


# If it's Helix Server / Helix DNA Server...
if (
  stridx(server, "Helix Server Version") == 0 || 
  stridx(server, "Helix DNA Server Version") == 0
)
{
  ver = ereg_replace(pattern:"^.+Version ([0-9\.][^ ]+) .+$", replace:"\1", string:server);
  if (ver && ver =~ "^([0-9]\.|10\.|11\.(0\.|1\.[0-2]\.))")
    security_hole(port);
}
