#
#  (C) Tenable Network Security, Inc.
#


 desc = "
Synopsis :

The remote Windows host has an ActiveX control that is affected by
remote code execution vulnerabilities. 

Description :

The remote host contains the HP Quick Launch Button software, part of
the HP Info Center software and installed by default on many HP and
Compaq laptop models. 

The version of this software on the remote host includes an ActiveX
control that reportedly contains three insecure methods -
'GetRegValue', 'SetRegValue', and 'LaunchApp' - that are marked as
'Safe for Scripting'.  If a remote attacker can trick a user on the
affected host into visiting a specially-crafted web page, he may be
able to leverage these issues to manipulate the remote registry or
launch arbitrary programs. 

See also :

http://www.securityfocus.com/archive/1/484880/30/0/threaded
http://www.nessus.org/u?1a49e1bc

Solution :

Apply the appropriate patch as discussed in the vendor advisory above
and ensure the version of the affected control is 2.0.0.0 or higher. 

Risk factor :

High / CVSS Base Score : 9.3
(CVSS2#AV:N/AC:M/Au:N/C:C/I:C/A:C)";


if (description)
{
  script_id(29725);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2007-6331", "CVE-2007-6332", "CVE-2007-6333");
  script_bugtraq_id(26823);

  script_name(english:"HP Info Center ActiveX Control Buffer Overflow Vulnerabilities");
  script_summary(english:"Checks version of HPInfoDLL ActiveX control"); 
 
  script_description(english:desc);
 
  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("smb_hotfixes.nasl");
  script_require_keys("SMB/Registry/Enumerated");
  script_require_ports(139, 445);

  exit(0);
}


include("global_settings.inc");
include("smb_func.inc");
include("smb_activex_func.inc");


if (!get_kb_item("SMB/Registry/Enumerated")) exit(0);


# Locate the file used by the controls.
if (activex_init() != ACX_OK) exit(0);

clsid = "{62DDEB79-15B2-41E3-8834-D3B80493887A}";
file = activex_get_filename(clsid:clsid);
if (file)
{
  # Check its version.
  ver = activex_get_fileversion(clsid:clsid);
  if (ver && activex_check_fileversion(clsid:clsid, fix:"2.0.0.0") == TRUE)
  {
    report = NULL;
    if (report_paranoia > 1)
      report = string(
        desc,
        "\n\n",
        "Plugin output :\n",
        "\n",
        "Version ", ver, " of the vulnerable control is installed as :\n",
        "\n",
        "  ", file, "\n",
        "\n",
        "Note, though, that Nessus did not check whether the 'kill' bit was\n",
        "set for the control's CLSID because of the Report Paranoia setting\n",
        "in effect when this scan was run.\n"
      );
    else if (activex_get_killbit(clsid:clsid) != TRUE)
      report = string(
        desc,
        "\n\n",
        "Plugin output :\n",
        "\n",
        "Version ", ver, " of the vulnerable control is installed as :\n",
        "\n",
        "  ", file, "\n",
        "\n",
        "Moreover, its 'kill' bit is not set so it is accessible via Internet\n",
        "Explorer.\n"
      );
    if (report) security_hole(port:kb_smb_transport(), data:report);
  }
}
activex_end();
