#
# (C) Tenable Network Security
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(16480);
 script_version ("$Revision: 1.1 $");

 name["english"] = "HP-UX Security patch : PHCO_11004";
 
 script_name(english:name["english"]);
 
 desc["english"] = '
The remote host is missing HP-UX Security Patch number PHCO_11004 .
(Security Vulnerability in swinstall command)

Solution : ftp://ftp.itrc.hp.com/superseded_patches/hp-ux_patches/s700_800/10.X/PHCO_11004
See also : HPUX security bulletin 064
Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for patch PHCO_11004";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005 Tenable Network Security");
 family["english"] = "HP-UX Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/HP-UX/swlist");
 exit(0);
}

include("hpux.inc");

if ( ! hpux_check_ctx ( ctx:"800:10.20 700:10.20 " ) )
{
 exit(0);
}

if ( hpux_patch_installed (patches:"PHCO_11004 PHCO_11315 PHCO_12128 PHCO_12448 PHCO_12673 PHCO_13029 PHCO_13282 PHCO_13399 PHCO_13626 PHCO_13777 PHCO_14199 PHCO_14511 PHCO_14868 PHCO_14891 PHCO_15153 PHCO_15465 PHCO_15807 PHCO_15808 PHCO_16302 PHCO_16303 PHCO_16723 PHCO_17381 PHCO_18018 PHCO_18338 PHCO_18644 PHCO_19181 PHCO_20098 PHCO_20441 PHCO_22448 PHCO_22924 PHCO_23684 PHCO_25640 PHCO_26158 PHCO_31920 ") )
{
 exit(0);
}

if ( hpux_check_patch( app:"OS-Core.C-MIN", version:NULL) )
{
 security_hole(0);
 exit(0);
}
if ( hpux_check_patch( app:"OS-Core.CORE-SHLIBS", version:NULL) )
{
 security_hole(0);
 exit(0);
}
if ( hpux_check_patch( app:"ProgSupport.PROG-AUX", version:NULL) )
{
 security_hole(0);
 exit(0);
}
if ( hpux_check_patch( app:"ProgSupport.PROG-MIN", version:NULL) )
{
 security_hole(0);
 exit(0);
}
