#
# (C) Tenable Network Security
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(23630);
 script_version ("$Revision: 1.4 $");

 name["english"] = "HP-UX Security patch : PHSS_35143";
 
 script_name(english:name["english"]);
 
 desc["english"] = '
The remote host is missing HP-UX Security Patch number PHSS_35143 .
(OV DP5.50 IA-64 patch - CORE packet)

Solution : ftp://ftp.itrc.hp.com//superseded_patches/hp-ux_patches/s700_800/11.X/PHSS_35143

Risk factor : High';

 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for patch PHSS_35143";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");
 family["english"] = "HP-UX Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/HP-UX/swlist");
 exit(0);
}

include("hpux.inc");

if ( ! hpux_check_ctx ( ctx:"11.23 " ) )
{
 exit(0);
}

if ( hpux_patch_installed (patches:"PHSS_35143 PHSS_35535 PHSS_36291 ") )
{
 exit(0);
}

if ( hpux_check_patch( app:"DATA-PROTECTOR.OMNI-CORE-IS", version:"A.05.50") )
{
 security_hole(0);
 exit(0);
}
if ( hpux_check_patch( app:"DATA-PROTECTOR.OMNI-FRA-LS-P", version:"A.05.50") )
{
 security_hole(0);
 exit(0);
}
if ( hpux_check_patch( app:"DATA-PROTECTOR.OMNI-INTEG-P", version:"A.05.50") )
{
 security_hole(0);
 exit(0);
}
if ( hpux_check_patch( app:"DATA-PROTECTOR.OMNI-JPN-LS-P", version:"A.05.50") )
{
 security_hole(0);
 exit(0);
}
