#
# (C) Tenable Network Security, Inc.
#


 desc["english"] = "
Synopsis :

Some information about the remote HTTP configuration can be extracted. 

Description :

This test gives some information about the remote HTTP protocol - the
version used, whether HTTP Keep-Alive and HTTP pipelining are enabled,
etc... 

This test is informational only and does not denote any security
problem

Solution :

None.

Risk factor :

None";


if(description)
{
 script_id(24260);
 script_version ("$Revision: 1.4 $");
 name["english"] = "HyperText Transfer Protocol Information";
 script_name(english:name["english"]);

 script_description(english:desc["english"]);

 summary["english"] = "Determines the version of HTTP spoken by the remote host";

 script_summary(english:summary["english"]);

 script_category(ACT_GATHER_INFO);


 script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");
 family["english"] = "Web Servers";
 script_family(english:family["english"]);
 script_dependencie("dotnet_framework_handlers.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}




include("http_func.inc");
include("http_keepalive.inc");
port = get_http_port(default:80);
if ( ! port )exit(0); 
soc = open_sock_tcp(port);
if ( ! soc ) exit(0);

req = 'GET / HTTP/1.1\r\nHost: ' + get_host_name() + '\r\n\r\n';
send(socket:soc, data:req);
r = http_recv(socket:soc);
if (r)
{
 version = ereg_replace(pattern:"^(HTTP/[0-9.]+).*", string:egrep(pattern:"HTTP/[0-9.]+ [0-9]+", string:chomp(r)), replace:"\1");
 send(socket:soc, data:req);
 r2 = http_recv(socket:soc);
 if ( r2 ) pipelining = "yes";
 else pipelining = "no";
}
else exit(0);
close(soc);

req = 'OPTIONS * HTTP/1.1\r\nHost: ' + get_host_name() + '\r\n\r\n';
soc = open_sock_tcp(port);
if (! soc ) exit(0);
send(socket:soc, data:req);
r = http_recv(socket:soc);
close(soc);
if ( r )
{
 line = egrep(pattern:"^Allow: ", string:r);
 if ( line ) options = ereg_replace(pattern:"^Allow: ", string:chomp(line), replace:"");
 else options = "(Not implemented)";
}

req = strcat('GET / HTTP/1.1\r\n',
'Connection: Keep-Alive\r\n',
'Host: ', get_host_name(), '\r\n\r\n');
soc = open_sock_tcp(port);
if (! soc ) exit(0);
send(socket:soc, data:req);
headers = r = http_recv_headers2(socket:soc);
close(soc);
if ( r )
{
 if ( egrep(pattern:"^Keep-Alive:", string:r) ||
      egrep(pattern:"^Connection: Keep-Alive", string:r) ) ka = "yes";
 else ka = "no";
}

report_g = desc["english"] + '\n\nPlugin output :\n\n';
report += 'Protocol version : ' + version + '\n';
if ( get_port_transport(port) > ENCAPS_IP ) report += 'SSL : yes\n';
else report += 'SSL : no\n';
if ( pipelining ) report += 'Pipelining : ' + pipelining + '\n';
if ( ka         ) report += 'Keep-Alive : ' + ka + '\n';
if ( options    ) report += 'Options allowed : ' + options + '\n';
if ( headers )
{
 headers -= egrep(pattern:"^HTTP.*", string:headers);
 headers_a  = split(headers);
 headers = NULL;
 foreach line ( headers_a )
	headers += '  ' + line;
	
 report += 'Headers :\n\n' + headers;
}

if ( ! report ) exit(0);
security_note(port:port, data:report_g + report);
