#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

 desc["english"] = "
Synopsis :

The remote host is affected by an information disclosure
vulnerability. 

Description :

The remote host answers to an ICMP_MASKREQ query and responds with its
netmask.  An attacker can use this information to understand how your
network is set up and how routing is done.  This may help him to
bypass your filters. 

Solution :

Reconfigure the remote host so that it does not answer to those
requests.  Set up filters that deny ICMP packets of type 17. 

Risk factor : 

None";


if(description)
{
 script_id(10113);
 script_version ("$Revision: 1.24 $");
 script_cve_id("CVE-1999-0524");
 name["english"] = "icmp netmask request";
 script_name(english:name["english"]);
 
 script_description(english:desc["english"]);
 
 summary["english"] = "Sends an ICMP_MASKREQ";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison");
 family["english"] = "Firewalls";
 script_family(english:family["english"]);

 
 exit(0);
}

#
# The script code starts here
#

if ( TARGET_IS_IPV6 ) exit(0);
if ( islocalhost() ) exit(0);

ip = forge_ip_packet(ip_hl:5, ip_v:4,   ip_off:0,
                     ip_id:9, ip_tos:0, ip_p : IPPROTO_ICMP,
                     ip_len : 20, ip_src : this_host(),
                     ip_ttl : 255);

icmp = forge_icmp_packet(ip:ip,icmp_type : 17, icmp_code:0,
                          icmp_seq : 1, icmp_id : 1, data:raw_string(0xFF, 0xFF, 0xFF, 0xFF));

filter = string("icmp and src host ", get_host_ip(), " and dst host ", this_host());
for(i=0;i<5;i++)
{
 r = send_packet(icmp, pcap_active:TRUE, pcap_filter:filter, pcap_timeout:1);
 if(!isnull(r))
 {
  type = get_icmp_element(icmp:r, element:"icmp_type");
  if(type == 18){
	data = get_icmp_element(icmp:r, element:"data");
	if ( strlen(data) != 4 ) exit(0);
	mask = "";
	for(i=0;i<4;i=i+1)
	{
   	 mask = string(mask, ord(data[i]));
	 if(i<3)mask = string(mask, ".");
	}

	report = string(
	 desc["english"],
	 "\n\n",
	 "Plugin output :\n",
	 "\n",
	 "  Netmask : ", mask, "\n"
	);
	security_note(protocol:"icmp", port:0, data:report); 
	set_kb_item(name: 'icmp/mask_req', value: TRUE);
  }
  exit(0);
 }
}
