#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(28331);
  script_version("$Revision: 1.1 $");

  script_name(english:"I Hear U Detection (UDP)");
  script_summary(english:"Initiates a call via UDP");

  desc = "
Synopsis :

A VoIP service is listening on the remote host. 

Description :

The remote service is the UDP port for IHU (I Hear U), a voice over IP
application for Linux used to streaming audio between two computers. 

See also :

http://ihu.sourceforge.net/

Solution :

Make sure the use of this software is done in accordance with your
corporate security policy.  If this service is unwanted or not needed,
disable it or filter incoming traffic to this port. 

Risk factor :

None";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Service detection");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  exit(0);
}


include("byte_func.inc");
include("misc_func.inc");


port = 1793;
if (known_service(port:port, ipproto:"udp")) exit(0);

soc = open_sock_udp(port);
if (!soc) exit(0);


# Ring the remote.
req = "IHU" +                          # HEADER_SYNC_STRING
  mkbyte(0x06) +                       # packet size
  mkbyte(0xff) +                       # info data (IHU_INFO_RING (0x3f) | IHU_INFO_MODE_ULTRAWIDE (0xc0)) 
  mkbyte(0x00);                        # data length
send(socket:soc, data:req);
res = recv(socket:soc, length:1024, min:6);


# If...
if (
  # the response is long-enough and...
  strlen(res) == 6 &&
  # it's a ring reply packet.
  res == "IHU"+mkbyte(0x06)+mkbyte(0x3e)+mkbyte(0x00)
)
{
  # Register and report the service.
  register_service(port:port, ipproto:"udp", proto:"ihu");
  security_note(port, proto:"udp");
}

