#
# (C) Tenable Network Security, Inc.
#
# Initial version written by John Lampe

if(description)
{
 script_id(10657);
 script_bugtraq_id(2674);
 script_version ("$Revision: 1.26 $");
 script_cve_id("CVE-2001-0241");
 script_xref(name:"IAVA", value:"2001-a-0005");
 script_xref(name:"OSVDB", value:"3323");
 name["english"] = "NT IIS 5.0 Malformed HTTP Printer Request Header Buffer Overflow Vulnerability";


 script_name(english:name["english"]);

 desc["english"] = "
Synopsis :

Arbitrary code can be execute on the remote host thru IIS

Description :

The remote version of the IIS web server contains a bug
which might be used by an attacker to execute arbitrary 
code on the remote system.

To exploit this vulnerability, an attacker would need to
send a specially malformed HTTP/1.1 request to the remote 
host containing an offensive payload.

Solution: 

http://www.microsoft.com/technet/security/bulletin/ms01-023.mspx

See also :

http://www.eeye.com/html/Research/Advisories/AD20010501.html 

Risk factor : 
Critical / CVSS Base Score : 10
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";

 script_description(english:desc["english"]);

 summary["english"] = "Makes sure that MS01-023 is installed on the remote host";

 script_summary(english:summary["english"]);
 script_category(ACT_ATTACK);
 script_dependencie("find_service1.nasl", "http_version.nasl", "www_fingerprinting_hmap.nasl");
 family["english"] = "Web Servers";
 script_family(english:family["english"]);
 script_copyright(english:"This script is Copyright (C) Tenable Network Security, Inc,");
 script_require_ports("Services/www", 80);
 exit(0);
}

# The attack starts here

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:80);
sig = get_kb_item("www/hmap/" + port + "/description");
if ( sig && "IIS" >!< sig ) exit(0);
if ( ! get_port_state(port) ) exit(0);
req = 'GET /NULL.printer HTTP/1.1\r\nHost: ' + crap(257) + '\r\n\r\n';

r = http_keepalive_send_recv(port:port, data:req);
if ( r =~ "HTTP/[0-9.]+ 500 13" ) security_hole(port);
