#
# (C) Tenable Network Security
#
# See the Nessus Scripts License for details
#
# Note that we need to be authenticated for this check
# to work properly.
#


if(description)
{
 script_id(11662);
 script_cve_id("CVE-2003-0377");
 script_bugtraq_id(7675);
 script_xref(name:"OSVDB", value:"4931");
 script_version("$Revision: 1.8 $");
 
 name["english"] = "iisPROTECT sql injection";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote web server contains an ASP application that is affected by
a SQL injection vulnerability. 

Description :

The remote host is running iisPROTECT, an IIS add-on to protect the
pages served by this server. 

There is a bug in the remote version of iisPROTECT that may allow an
attacker with the ability to browse the administrative interface to
execute arbitrary commands through SQL injection on this host. 

See also :

http://www.securityfocus.com/archive/1/322387/30/0/threaded

Solution : 

Upgrade to iisPROTECT version 2.3 or later as that is rumoured to
address the issue. 

Risk factor : 

Medium / CVSS Base Score : 6.5
(CVSS2#AV:N/AC:L/Au:S/C:P/I:P/A:P)";
 script_description(english:desc["english"]);
 
 summary["english"] = "Determines if iisPROTECT is password-protected";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2003-2007 Tenable Network Security");
 family["english"] = "CGI abuses";
 script_family(english:family["english"]);
 script_dependencie("find_service1.nasl", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

# Check starts here

include("http_func.inc");
include("http_keepalive.inc");



port = get_http_port(default:80);


if(get_port_state(port))
{
 req = http_get(item:"/iisprotect/admin/SiteAdmin.ASP?V_SiteName=&V_FirstTab=Groups&V_SecondTab=All&GroupName=nessus", port:port);
 res = http_keepalive_send_recv(port:port, data:req);
 if( res == NULL ) exit(0);
 if("Microsoft OLE DB Provider" >< res)exit(0);
 
 req = http_get(item:"/iisprotect/admin/SiteAdmin.ASP?V_SiteName=&V_FirstTab=Groups&V_SecondTab=All&GroupName=nessus'", port:port);
 res = http_keepalive_send_recv(port:port, data:req);
 if( res == NULL ) exit(0);
 if("Microsoft OLE DB Provider" >< res)security_warning(port);
}
