#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#
#
#

if(description)
{
 script_id(10129);
 script_bugtraq_id(1443, 616, 687);
 script_version ("$Revision: 1.21 $");
 script_cve_id("CVE-1999-0705","CVE-1999-0043","CVE-1999-0247");
 name["english"] = "INN version check";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote NNTP server is affected by multiple vulnerabilities.

Description :

According to its banner, the remote version of INN is older than
version 1.6.  A number of security holes have been found older
versions of INN, some of which may allow arbitrary command execution. 

See also :

http://www.cert.org/advisories/CA-1997-08.html
http://www.ciac.org/ciac/bulletins/h-85.shtml

Solution : 

Upgrade to version 1.6 or later.

Risk factor : 

Critical / CVSS Base Score : 10.0
(CVSS2#AV:N/AC:L/Au:N/C:C/I:C/A:C)";
 script_description(english:desc["english"]);
 
 summary["english"] = "Checks INN version";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison");
 family["english"] = "Gain root remotely";
 script_family(english:family["english"]);
 script_dependencie("find_service1.nasl");
 script_require_ports("Services/nntp", 119);
 exit(0);
}

#
# The script code starts here
#



# Read the banner from the knowledge base,
# or get it by connecting to the server
# manually


port = get_kb_item("Services/nntp");
if(!port)port = 119;

key = string("nntp/banner/", port);
banner = get_kb_item(key);

if(!banner)
{
 if(get_port_state(port))
 {
  soc = open_sock_tcp(port);
  if(soc)
  {
   banner = recv_line(socket:soc,length:1024);
   close(soc);
  }
 }
}



if(!banner)exit(0);
s = strstr(banner,"INN");
 if(s)
 {
  version = s[4];
  subversion = s[6];
  if((version == 1)&&(subversion < 6))
	{ security_hole(port); }

 }

