#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(25626);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-3502");
  script_bugtraq_id(24692);
  script_xref(name:"OSVDB", value:"37217");

  script_name(english:"Kaspersky Anti-Spam Control Center Information Disclosure Vulnerability");
  script_summary(english:"Tries to get a directory listing");

  desc = "
Synopsis :

The remote web server is susceptible to an information disclosure
attack. 

Description :

The remote host appears to be running Kaspersky Anti-Spam's Control
Center. 

The version of the Kaspersky Anti-Spam Control Center installed on the
remote host fails to require authentication for access to directories
under the service's document root.  An unauthenticated remote attacker
may be able to leverage this issue to obtain sensitive information
from the remote host. 

Note that the Control Center listens only on the loopback interface by
default. 

See also :

http://www.kaspersky.com/technews?id=203038700

Solution :

Apply Critical Fix 1 for Kaspersky Anti-Spam 3.0 MP1.

Risk factor : 

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 3080);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:3080);
if (!get_port_state(port)) exit(0);


# Make sure it's KAS.
if (report_paranoia < 2)
{
  banner = get_http_banner(port:port);
  if (!banner || "Server: thttpd/" >!< banner) exit(0);
}

req = http_get(item:"/aslic_status.cgi", port:port);
res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
if (res == NULL) exit(0);


# If so...
if ("Authorization required for the URL '/aslic_status.cgi'" >< res)
{
  # Try to exploit the vulnerability to get a directory listing.
  req = http_get(item:"/stat/", port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if we get a directory listing.
  if ("<TITLE>Index of /stat/</TITLE>" >< res)
    security_hole(port);
}
