#
# (C) Tenable Network Security
#


if (description)
{
  script_id(23997);
  script_version("$Revision: 1.6 $");

  script_cve_id("CVE-2007-0125");
  script_bugtraq_id(21901);
  script_xref(name:"OSVDB", value:"32588");

  script_name(english:"Kaspersky Antivirus PE File Denial of Service Vulnerability");
  script_summary(english:"Checks date of virus signatures");

  desc = "
Synopsis :

The remote Windows host contains an antivirus application that is
prone to a denial of service attack. 

Description :

The version of Kaspersky Antivirus installed on the remote host is
affected by a denial of service issue that can be triggered with a
specially-crafted PE (portable executable) file to send the scanning
engine into an infinite loop and prevent scanning of other files. 

See also :

http://labs.idefense.com/intelligence/vulnerabilities/display.php?id=459
http://www.securityfocus.com/archive/1/456110/30/0/threaded

Solution :

Update the virus signatures to 01/02/2007 or later. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:N/I:N/A:P)";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Windows");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("kaspersky_installed.nasl");
  script_require_keys("Antivirus/Kaspersky/sigs");

  exit(0);
}


sigs = get_kb_item("Antivirus/Kaspersky/sigs");
if (sigs)
{
  sigs = split(sigs, sep:'/', keep:FALSE);
  if (
    sigs[0] == "unknown" ||
    int(sigs[2]) < 2007 || 
    (int(sigs[2]) == 2007 && int(sigs[0]) == 1 && int(sigs[1]) <= 2)
  )
  security_warning(get_kb_item("SMB/transport"));
}

