#
# (C) Tenable Network Security
#


if (description)
{
  script_id(23782);
  script_version ("$Revision: 1.7 $");

  script_cve_id("CVE-2006-6343", "CVE-2006-6577");
  script_bugtraq_id(21366);
  script_xref(name:"OSVDB", value:"31712");
  script_xref(name:"OSVDB", value:"32036");

  script_name(english:"Land Down Under / Seditio id parameter SQL Injection Vulnerability");
  script_summary(english:"Checks for SQL injection vulnerability in Land Down Under / Seditio");
 
  desc = "
Synopsis : 

The remote web server contains a PHP script that is affected by a SQL
injection vulnerability. 

Description :

The remote version of Land Down Under or Seditio fails to sanitize
input to the 'id' parameter of the 'polls.php' script before using it
in a database query.  Provided PHP's 'magic_quotes_gpc' setting is
disabled, an unauthenticated attacker may be able to leverage this
issue to uncover sensitive information (such as password hashes),
modify existing data, or launch attacks against the underlying
database. 

See also : 

http://milw0rm.com/exploits/2871

Solution :

Unknown at this time. 

Risk factor : 

Medium / CVSS Base Score : 6.8
(CVSS2#AV:N/AC:M/Au:N/C:P/I:P/A:P)";
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2006-2008 Tenable Network Security");

  script_dependencies("ldu_detection.nasl", "seditio_detect.nasl");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Test any installs.
kb1 = get_kb_list(string("www/", port, "/ldu"));
if (isnull(kb1)) kb1 = make_list();
else kb1 = make_list(kb1);

kb2 = get_kb_list(string("www/", port, "/seditio"));
if (isnull(kb2)) kb2 = make_list();
else kb2 = make_list(kb2);

installs = make_list(kb1, kb2);
foreach install (installs)
{
  matches = eregmatch(string:install, pattern:"^(.+) under (/.*)$");
  if (!isnull(matches))
  {
    dir = matches[2];

    # Try to exploit the flaw to cause a SQL error.
    req = http_get(
      item:string(
        dir, "/polls.php?",
        "id='", SCRIPT_NAME
      ), 
      port:port
    );
    res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
    if (res == NULL) exit(0);

    # There's a problem if we see a database error with our script name.
    if (
      "MySQL error" >< res &&
      string("'", SCRIPT_NAME, "' AND poll_state=0") >< res
    ) 
    {
      security_warning(port);
      exit(0);
    }
  }
}

