#
# (C) Tenable Network Security, Inc.
#


  desc = "
Synopsis :

The remote web server is affected by an information disclosure
vulnerability. 

Description :

The installation of lighttpd on the remote host allow unauthenticated
access to URLs associated with the Status module (mod_status), at
least from the Nessus server.  Mod_status reports information about
how the web server is configured and its usage, and it may prove
useful to an attacker seeking to attack the server or host. 

See also :

http://trac.lighttpd.net/trac/wiki/Docs%3AModStatus

Solution :

Reconfigure lighttpd to require authentication for the affected
URL(s), restrict access to them by IP address, or disable the Status
module itself. 

Risk factor :

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:P/I:N/A:N)";


if (description)
{
  script_id(26058);
  script_version("$Revision: 1.1 $");

  script_name(english:"Lighttpd Status Module Information Disclosure Vulnerability");
  script_summary(english:"Sends requests for status urls");

  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Web Servers");

  script_copyright(english:"This script is Copyright (C) 2007 Tenable Network Security, Inc.");

  script_dependencies("http_version.nasl");
  script_require_keys("www/lighttpd");
  script_require_ports("Services/www", 80);

  exit(0);
}


include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");


port = get_http_port(default:80);
if (!get_port_state(port)) exit(0);


# Make sure the banner looks like lighttpd.
banner = get_http_banner(port:port);
if (
  !banner || 
  "lighttpd/" >!< banner
) exit(0);


# Try to retrieve the possible default URLs.
urls = make_list("/server-status", "/server-config", "/server-statistics");

info = "";
foreach url (urls)
{
  req = http_get(item:url, port:port);
  res = http_keepalive_send_recv(port:port, data:req, bodyonly:TRUE);
  if (res == NULL) exit(0);

  if (
    ("status" >< url     && ">Server-Status<" >< res) ||
    ("config" >< url     && ">Server-Features<" >< res) ||
    ("statistics" >< url && "fastcgi.backend." >< res)
  )
  {
    info += '  ' + url + '\n';
    if (!thorough_tests) break;
  }
}


# Report any findings.
if (info)
{
  nurls = max_index(split(info));

  report = string(
    desc,
    "\n\n",
    "Plugin output :\n",
    "\n",
    "Nessus found ", nurls, " URL(s) associated with the Status module enabled :\n",
    "\n",
    info
  );

  if (!thorough_tests)
  {
    report = string(
      report,
      "\n",
      "Note that Nessus did not check whether there were other instances\n",
      "installed because the Thorough Tests setting was not enabled when\n",
      "this scan was run.\n"
    );
  }

  security_warning(port:port, data:report);
}
