#
# (C) Tenable Network Security, Inc.
#


if (description)
{
  script_id(30207);
  script_version("$Revision: 1.4 $");

  script_name(english:"LPD Detection");
  script_summary(english:"Sends various LPD commands");

  desc = "
Synopsis :

A printer service is listening on the remote host. 

Description :

The remote service supports the line printer daemon (lpd) protocol,
which is widely-used by print servers. 

See also :

http://tools.ietf.org/html/rfc1179

Solution :

Limit incoming traffic to this port if desired. 

Risk factor :

None";
  script_description(english:desc);

  script_category(ACT_GATHER_INFO);
  script_family(english:"Service detection");

  script_copyright(english:"This script is Copyright (C) 2008 Tenable Network Security, Inc.");

  script_dependencies("find_service2.nasl");
  script_require_ports("Services/unknown", 515);

  exit(0);
}


include("byte_func.inc");
include("global_settings.inc");
include("misc_func.inc");


if (
  thorough_tests &&
  !get_kb_item("global_settings/disable_service_discovery")
)
{
  port = get_unknown_svc(515);
  if (!port) exit(0);
}
else port = 515;
if (known_service(port:port)) exit(0);
if (!get_tcp_port_state(port)) exit(0);


# Query a print queue.
queue = string("nessus-", unixtime());

soc = open_priv_sock_tcp(dport:port);
if (!soc) exit(0);

req = mkbyte(4) + queue + " " + mkbyte(0x0a);
send(socket:soc, data:req); 
res = recv(socket:soc, length:1024, min:1);
close(soc);


# If it looks like a valid response...
if (strlen(res))
{
  lres = tolower(res);
  if (
    "lpd: printer not found" >< lres ||
    "no entries" >< lres ||
    "no jobs queued" >< lres ||
    string("queue '", queue, "' is empty.") >< lres
  )
  {
    # Register and report the service.
    register_service(port:port, proto:"lpd");

    security_note(port);
    exit(0);
  }
}


# Try printing any waiting jobs for our queue.
#
# nb: some servers only provide a a single-byte response to this.
soc = open_priv_sock_tcp(dport:port);
if (!soc) exit(0);

req = mkbyte(1) + queue + " " + mkbyte(0x0a);
send(socket:soc, data:req); 
res = recv(socket:soc, length:64, min:1);
close(soc);


# If the response looks right...
if (
  strlen(res) &&
  (getbyte(blob:res, pos:0) == 0 || getbyte(blob:res, pos:0) == 1) &&
  (
    "Invalid queue" >< res ||
    (strlen(res) == 1 && report_paranoia > 1)
  )
)
{
  # Register and report the service.
  register_service(port:port, proto:"lpd");

  if (report_verbosity && strlen(res) == 1 && report_paranoia > 1)
  {
    note = string(
      "\n",
      "Note that Nessus only received a single byte in response to a command\n",
      "to print any waiting jobs for a queue.  While this method is not\n",
      "completely reliable, Nessus used it because the Report Paranoia\n",
      "setting in effect when this scan was run was set to 'Paranoid'.\n"
    );
    security_note(port:port, extra:note);
  }
  else security_note(port);
}
