#TRUSTED 7ab42fee9fc5a86f9deb9b3ab2237639397a778f1f1d82573307cf39a873d3f593467e4443757cf98008b0c5a227c1313a2bc7f72e409daf9e90294848cecc3d69fc505e0fe3d39b5e0d005f38e5b4f3ca43be113999d3c893de572b9a17d824e3841e8e632eb7599d6900752195ce148fce59a81419c934b5e571775543bd9b45b8d7d1ecb9072602fc755dac03397ddada0f9073dfd342b0256948a10f8248d71f3474a335da584f209b095b0c9d70ac510beaaf4216cc8e72b7147a30af202e6ed07bf56b0ad87f9ab7fc2aff1685526f6945ee58111d926b22d0140701e60aef27c1ac92129bf021760cc959e1b60c3cfdf11371d7e26dfd3a4028c9fbc0a9129373f846bdb7c8455f5dbfeb96db8999444e689959a7766cd206391e4818c43737c1de5ad13034a70e05e1cc86867948a20f8c163fe18cf1ffc82f14b4f28197d6a24507f4b149fec78af3306fae213169f08e29c1ceb802244144f82c57456d0ebdb7539d7d6d794e42a2e7e0309c92cf2bda41f3be702542cda194c86c03809463e4a6c5eb21dac2109f5d2aab15cad008096528db603d597148cb21d6edc7b22c61397b74e87d805c655d70e42f789af8feb506d7b9cc05e89c0243b087fc48d4622389d1225743113666b10d83a1a044c425e9ed66c7d6fa509c1e326b2f6007569d53b9a35efc404baae1e3afda6ea4ed27d6a1902d668cc7120755
#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(22418);
 script_version ("1.0");
 script_bugtraq_id(20144);
 script_cve_id("CVE-2006-3507", "CVE-2006-3508", "CVE-2006-3509");
 
 name["english"] = "AirPort Update 2006-001 / Security Update 2006-005";
 

 script_name(english:name["english"]);
 
 desc["english"] = "
Synopsis :

Arbitrary code can be executed on the remote host through the AirPort 
Wireless card.

Description :

The remote host is missing a security update regarding the drivers of 
the AirPort wireless card.

An attacker in the proximity of the target host may exploit this flaw 
by sending malformed 802.11 frames to the remote host and cause a stack 
overflow resulting in a crash of arbitrary code execution.

Solution : 

Apple has released a patch for this issue :
http://docs.info.apple.com/article.html?artnum=304420

Risk factor : 

High / CVSS Base Score : 7.2
(CVSS2#AV:L/AC:L/Au:N/C:C/I:C/A:C)";



 script_description(english:desc["english"]);
 
 summary["english"] = "Checks for the version of the Airport drivers";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2006 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 script_require_keys("Host/MacOSX/packages");
 exit(0);
}


include("ssh_func.inc");
include("macosx_func.inc");

function vulnerable()
{
 security_hole( port : 0 );
 if ( ! localhost ) ssh_close_connection();
 exit(0);
}
 
function cmd()
{
 local_var buf;
 local_var soc;

 if ( islocalhost() )
	return pread(cmd:"bash", argv:make_list("bash", "-c", _FCT_ANON_ARGS[0]));
 
 soc = ssh_login_or_reuse_connection();
 if ( ! soc ) exit(0);
 buf = ssh_cmd(socket:soc, cmd:_FCT_ANON_ARGS[0]);
 ssh_close_connection();
 return buf;
}


uname = get_kb_item("Host/uname");
if ( "Darwin" >!< uname ) exit(0);


#
# Mac OS X < 10.4.7 is affected
#
if ( uname =~ "Version 8\.[0-6]\." ) vulnerable();

#
# Mac OS X < 10.3.9 is affected
# 
if ( uname =~ "Version 7\.[0-8]\." ) vulnerable();



get_build   = "system_profiler SPSoftwareDataType";
has_airport = "system_profiler SPAirPortDataType";
atheros  = GetBundleVersionCmd(file:"AirPortAtheros5424.kext", path:"/System/Library/Extensions/IO80211Family.kext/Contents/PlugIns/");
broadcom = GetBundleVersionCmd(file:"AppleAirPortBrcm4311.kext", path:"/System/Library/Extensions/IO80211Family.kext/Contents/PlugIns/");


  
build = cmd(get_build);
airport = cmd(has_airport);
if ( "Wireless Card Type: AirPort" >!< airport ) exit(0);  # No airport card installed

#
# AirPort Update 2006-001
#	-> Mac OS X 10.4.7 Build 8J2135 and 8J2135a
#
if ( egrep(pattern:"System Version: Mac OS X 10\.4\.7 \(8J2135a?", string:build) )
{
 atheros_version = cmd(atheros);
 broadcom_version = cmd(broadcom);
 if ( atheros_version =~ "^1\." )
	{
	 v = split(atheros_version, sep:'.', keep:FALSE);
	 if ( int(v[0]) == 1 && int(v[1]) == 0 && int(v[2]) < 5 ) vulnerable();
	}
 if ( broadcom =~ "^1\." )
	{
	 v = split(broadcom_version, sep:'.', keep:FALSE);
	 if ( int(v[0]) == 1 && int(v[1]) == 0 && int(v[2]) < 4 ) vulnerable();
	}
}
#
# Mac OS X Security Update 2006-005 (Tiger)
#	-> Mac OS X 10.4.7 build 8J135
#	-> Mac OS X 10.3.9 build 7W98
#
else if ( egrep(pattern:"System Version: Mac OS X 10\.4\.7 \(8J135", string:build) ||
          egrep(pattern:"System Version: Mac OS X 10\.3\.9 ", string:build) )
{
  cmd = GetBundleVersionCmd(file:"/AppleAirPort2.kext", path:"/System/Library/Extensions");
  airport_version = cmd(cmd);
  if ( airport_version =~ "^4\. " )
  {
	 v = split(atheros_version, sep:'.', keep:FALSE);
	 if ( int(v[0]) == 4 && int(v[1]) == 0 && int(v[2]) < 5 ) vulnerable();
  }
}


if ( ! localhost ) ssh_close_connection();
