#TRUSTED 74af71ba49204361a19a430b7868b6d621f1c237d397aa68f25351e01ce67c4677269977568a0d578638d32fe788cc2414ce9190aa78819bc505ad465ceedbb422e25fc223ab5052b26ecc69e8c2b3e46f0f828142bcbc8e04c5006acd787a6c9b0aea1f1c64f3c750c8c25f4ec2a176368f67198754e97ca8fcec7f3f1c6b1764106fc962274bfa086a943ff57ee3988e61dfe371c4a0496b8efb762f3599d86155be0a528c062a3411bcbd5319a5157237013273870177c65b1b1f9346a8c1eb0e7145851fa5adca61f4b48f516da6ddebadf1e76c1c675bb654ff732040e94e418569169c519dba57c05975b66dde9344a34d7504f70a24c7255afecdaebb4eb3eb1bdb41be768f5e1d8dca5c419239a6cd9563f9846c859d43e62416ffb9c6095bf5138c0f7ca1242fa0f9e16812aa58f630e37469bad981cf196d6e99d3126833a36c723a81f6965455f492ef589258ee8b8ef71894fdcdd967bc1724ee3311286a9bbabcdd196884b9c12f3004c1931afc4af4765d63051e20bbf41f95ecadb599ed74e79b2a5291ee5d8cf34d3313eeda3a0502439f49d0425486648400a5ef06b4390c2e43b4ed0ed71b2d7641c2f69cbfee54906947471a57cf214309b2658ac65375a2aadec3bfa836e1317fd06972be623f8b0f808e893a7257a4e2b1c5ca8368fed5b5c980be77c83f1350c040165fc05e14b3d04696a0c62d65
#
# (C) Tenable Network Security
#
#

if ( ! defined_func("bn_random") ) exit(0);
if(description)
{
 script_id(19295);
 script_version ("1.0");
 script_bugtraq_id(14321);
 script_cve_id("CVE-2005-2196");
 name["english"] = "Airport < 4.2";
 
 script_name(english:name["english"]);
 
 desc["english"] = "
The remote host is running a version of Mac OS X which contains an Airport 
driver which is vulnerable to an automatic network association vulnerability, 
which may cause a computer to connect to potentially malicious networks without
notifying the end-user.

Solution : Upgrade to Airport 4.2
See also : http://docs.info.apple.com/article.html?artnum=301988
Risk factor : Medium";


 script_description(english:desc["english"]);
 
 summary["english"] = "Check for the version of Mac OS X";
 script_summary(english:summary["english"]);
 
 script_category(ACT_GATHER_INFO);
 
 script_copyright(english:"This script is Copyright (C) 2005 Tenable Network Security");
 family["english"] = "MacOS X Local Security Checks";
 script_family(english:family["english"]);
 
 script_dependencies("ssh_get_info.nasl");
 #script_require_keys("Host/MacOSX/packages");
 exit(0);
}


include("ssh_func.inc");
include("macosx_func.inc");

packages = get_kb_item("Host/MacOSX/packages");
if ( ! packages ) exit(0);
os = get_kb_item("Host/MacOSX/Version");
if ( ! os ) exit(0);

cmd = GetBundleVersionCmd(file:"AirPort Admin Utility.app", path:"/Applications/Utilities");

if ( !ereg(pattern:"Mac OS X 10\.(3|4\.[012]([^0-9]|$))", string:os) ) exit(0);

if ( islocalhost() )
{
 buf = pread(cmd:"grep", argv:make_list("bash", "-c", cmd));
}
else 
{
 sock = ssh_login_or_reuse_connection();
 if ( ! sock ) exit(0);
 buf = ssh_cmd(socket:sock, cmd:cmd);
 ssh_close_connection();
}


if ( buf && ereg(pattern:"^([0-3]\.|4\.[01](\..*)?)", string:buf) ) security_hole(0);
